/*= GM SSP X Power Source (VISA)  Include File ==============================*/

/*===========================================================================*/
/*  Please do not use global variables or arrays in the include file of      */
/*  instrument drivers that will be submitted for inclusion into the         */
/*  LabWindows Instrument Driver Library.                                    */
/*===========================================================================*/
     
#ifndef __gmsspx_HEADER
#define __gmsspx_HEADER

#include <vpptype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*****************************************************************************/
/*= Instrument Driver Specific Error/Warning Codes ==========================*/
/*****************************************************************************/
#define VI_ERROR_INSTR_INTERPRETING_RESPONSE    (_VI_ERROR+0x3FFC0803L)

/*****************************************************************************/
/*= Define Instrument Specific Error/Warning Codes Here =====================*/
/*****************************************************************************/
#define VI_ERROR_INSTR_OFFSET                   (_VI_ERROR+0x3FFC0900L)

#define GMSSPX_ERROR_INSTRUMENT_ERROR           (VI_ERROR_INSTR_OFFSET + 0xF0L)
#define GMSSPX_ERROR_UNKNOWN_INSTR_MODEL    (VI_ERROR_INSTR_OFFSET + 0xF1L)
#define GMSSPX_ERROR_NOSUP_FUNC_MODEL           (VI_ERROR_INSTR_OFFSET + 0xF2L)
#define GMSSPX_ERROR_INVALID_CONFIGURATION      (VI_ERROR_INSTR_OFFSET + 0xF3L)
#define GMSSPX_ERROR_QUERY_ERROR                (VI_ERROR_INSTR_OFFSET + 0xF4L)
#define GMSSPX_ERROR_EXECUTION_ERROR            (VI_ERROR_INSTR_OFFSET + 0xF5L)
#define GMSSPX_ERROR_COMMAND_ERROR              (VI_ERROR_INSTR_OFFSET + 0xF6L)
#define GMSSPX_ERROR_LIMIT_ERROR                (VI_ERROR_INSTR_OFFSET + 0xF7L)
#define GMSSPX_ERROR_DDT_ERROR                  (VI_ERROR_INSTR_OFFSET + 0xF8L)
#define GMSSPX_ERROR_OUT_ERROR                  (VI_ERROR_INSTR_OFFSET + 0xF9L)
#define GMSSPX_ERROR_SEQ_ERROR                  (VI_ERROR_INSTR_OFFSET + 0xFAL)

/*****************************************************************************/
/*= GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions) =======*/
/*****************************************************************************/

ViStatus _VI_FUNC gmsspx_init (ViRsrc resourceName, ViBoolean IDQuery,
                               ViBoolean resetDevice, ViPSession instrumentHandle);
ViStatus _VI_FUNC gmsspx_AppExample (ViSession instrumentHandle,
                                     ViReal64 voltageLimitinV,
                                     ViReal64 currentLimitinA,
                                     ViReal64 voltageSettinginV,
                                     ViReal64 currentSettinginA,
                                     ViPReal64 outputVoltageinV,
                                     ViPReal64 outputCurrentinA);
ViStatus _VI_FUNC gmsspx_confSetVolt (ViSession instrumentHandle,
                                      ViReal64 voltageSettinginV);
ViStatus _VI_FUNC gmsspx_confGetVolt (ViSession instrumentHandle,
                                      ViPReal64 voltageSettinginV);
ViStatus _VI_FUNC gmsspx_confSetVoltLimit (ViSession instrumentHandle,
                                           ViReal64 voltageLimitinV);
ViStatus _VI_FUNC gmsspx_confGetVoltLimit (ViSession instrumentHandle,
                                           ViPReal64 voltageLimitinV);
ViStatus _VI_FUNC gmsspx_confSetOVPLevel (ViSession instrumentHandle,
                                          ViReal64 OVPLevelinV);
ViStatus _VI_FUNC gmsspx_confGetOVPLevel (ViSession instrumentHandle,
                                          ViPReal64 OVPLevelinV);
ViStatus _VI_FUNC gmsspx_confGetVoltMax (ViSession instrumentHandle,
                                         ViPReal64 maxVoltageinV);
ViStatus _VI_FUNC gmsspx_confSetCurrent (ViSession instrumentHandle,
                                         ViReal64 currentSettinginA);
ViStatus _VI_FUNC gmsspx_confGetCurrent (ViSession instrumentHandle,
                                         ViPReal64 currentSettinginA);
ViStatus _VI_FUNC gmsspx_confSetCurrLimit (ViSession instrumentHandle,
                                           ViReal64 currentLimitinA);
ViStatus _VI_FUNC gmsspx_confGetCurrLimit (ViSession instrumentHandle,
                                           ViPReal64 currentLimitinA);
ViStatus _VI_FUNC gmsspx_confSetOCPDelay (ViSession instrumentHandle,
                                          ViReal64 OCPDelayinsec);
ViStatus _VI_FUNC gmsspx_confGetOCPDelay (ViSession instrumentHandle,
                                          ViPReal64 OCPDelayinsec);
ViStatus _VI_FUNC gmsspx_confSetOCPState (ViSession instrumentHandle,
                                          ViBoolean OCPState);
ViStatus _VI_FUNC gmsspx_confGetOCPState (ViSession instrumentHandle,
                                          ViPBoolean OCPState);
ViStatus _VI_FUNC gmsspx_confGetCurrMax (ViSession instrumentHandle,
                                         ViPReal64 maxCurrentinA);
ViStatus _VI_FUNC gmsspx_confSetOutputState (ViSession instrumentHandle,
                                             ViBoolean outputState);
ViStatus _VI_FUNC gmsspx_confGetOutputState (ViSession instrumentHandle,
                                             ViPBoolean outputState);
ViStatus _VI_FUNC gmsspx_confGetOutputMode (ViSession instrumentHandle,
                                            ViPInt32 outputMode);
ViStatus _VI_FUNC gmsspx_confSetSeq (ViSession instrumentHandle,
                                     ViBoolean sequenceState, ViInt32 startAddress,
                                     ViInt32 stopAddress,
                                     ViInt32 sequenceRepetition,
                                     ViReal64 defaultTimeinsec);
ViStatus _VI_FUNC gmsspx_confSetSeqState (ViSession instrumentHandle,
                                          ViBoolean sequenceState);
ViStatus _VI_FUNC gmsspx_confGetSeqState (ViSession instrumentHandle,
                                          ViPBoolean sequenceState);
ViStatus _VI_FUNC gmsspx_confSetSeqRepetition (ViSession instrumentHandle,
                                               ViInt32 sequenceRepetition);
ViStatus _VI_FUNC gmsspx_confGetSeqRepetition (ViSession instrumentHandle,
                                               ViPInt32 sequenceRepetition);
ViStatus _VI_FUNC gmsspx_confSetSeqRange (ViSession instrumentHandle,
                                          ViInt32 startAddress, ViInt32 stopAddress);
ViStatus _VI_FUNC gmsspx_confGetSeqRange (ViSession instrumentHandle,
                                          ViPInt32 startAddress,
                                          ViPInt32 stopAddress);
ViStatus _VI_FUNC gmsspx_confSetSeqDefaultTime (ViSession instrumentHandle,
                                                ViReal64 defaultTimeinsec);
ViStatus _VI_FUNC gmsspx_confGetSeqDefaultTime (ViSession instrumentHandle,
                                                ViPReal64 defaultTimeinsec);
ViStatus _VI_FUNC gmsspx_confSetSeqTime (ViSession instrumentHandle,
                                         ViReal64 stepTimeinsec);
ViStatus _VI_FUNC gmsspx_confGetSeqTime (ViSession instrumentHandle,
                                         ViPReal64 stepTimeinsec);
ViStatus _VI_FUNC gmsspx_confSetSignalFunc (ViSession instrumentHandle,
                                            ViInt32 signal1, ViInt32 signal2);
ViStatus _VI_FUNC gmsspx_confGetSignalFunc (ViSession instrumentHandle,
                                            ViPInt32 signal1, ViPInt32 signal2);
ViStatus _VI_FUNC gmsspx_confSetTriggerMode (ViSession instrumentHandle,
                                             ViInt32 triggerMode);
ViStatus _VI_FUNC gmsspx_confGetTriggerMode (ViSession instrumentHandle,
                                             ViPInt32 triggerMode);
ViStatus _VI_FUNC gmsspx_confSetSset (ViSession instrumentHandle, ViBoolean SSet);
ViStatus _VI_FUNC gmsspx_confGetSset (ViSession instrumentHandle, ViPBoolean SSet);
ViStatus _VI_FUNC gmsspx_confSetMinMaxState (ViSession instrumentHandle,
                                             ViBoolean minMaxState);
ViStatus _VI_FUNC gmsspx_confGetMinMaxState (ViSession instrumentHandle,
                                             ViPBoolean minMaxState);
ViStatus _VI_FUNC gmsspx_confSetPwrOnMode (ViSession instrumentHandle,
                                           ViInt32 powerOnMode);
ViStatus _VI_FUNC gmsspx_confGetPwrOnMode (ViSession instrumentHandle,
                                           ViPInt32 powerOnMode);
ViStatus _VI_FUNC gmsspx_actSendSeqTrigger (ViSession instrumentHandle,
                                            ViInt32 sequenceControl);
ViStatus _VI_FUNC gmsspx_resetMinMax (ViSession instrumentHandle);
ViStatus _VI_FUNC gmsspx_fetchMinMax (ViSession instrumentHandle,
                                      ViPReal64 minVoltageinV,
                                      ViPReal64 maxVoltageinV,
                                      ViPReal64 minCurrentinA,
                                      ViPReal64 maxCurrentinA);
ViStatus _VI_FUNC gmsspx_measOutVolt (ViSession instrumentHandle,
                                      ViPReal64 outputVoltage);
ViStatus _VI_FUNC gmsspx_measOutCurr (ViSession instrumentHandle,
                                      ViPReal64 outputCurrent);
ViStatus _VI_FUNC gmsspx_measOutPower (ViSession instrumentHandle,
                                       ViPReal64 outputPowerinW);
ViStatus _VI_FUNC gmsspx_dataRecallRegister (ViSession instrumentHandle,
                                             ViInt32 recallRegisterNo);
ViStatus _VI_FUNC gmsspx_dataSaveRegister (ViSession instrumentHandle,
                                           ViInt32 saveRegisterNo);
ViStatus _VI_FUNC gmsspx_dataStoreReg (ViSession instrumentHandle,
                                       ViInt32 registerNo,
                                       ViReal64 voltageSettinginV,
                                       ViReal64 currentSettinginA,
                                       ViReal64 stepTimeinsec, ViInt32 SSet);
ViStatus _VI_FUNC gmsspx_dataReadReg (ViSession instrumentHandle,
                                      ViInt32 registerNo,
                                      ViPReal64 voltageSettinginV,
                                      ViPReal64 currentSettinginA,
                                      ViPReal64 stepTimeinsec, ViPInt32 SSet);
ViStatus _VI_FUNC gmsspx_dataStoreRegDataArr (ViSession instrumentHandle,
                                              ViInt32 startRegisterNo,
                                              ViReal64 _VI_FAR voltageSettinginV[],
                                              ViReal64 _VI_FAR currentSettinginA[],
                                              ViReal64 _VI_FAR stepTimeinsec[],
                                              ViInt32 _VI_FAR SSet[],
                                              ViInt32 numberOfElements);
ViStatus _VI_FUNC gmsspx_utilSetReg (ViSession instrumentHandle,
                                     ViInt32 systemRegisterName, ViInt32 value);
ViStatus _VI_FUNC gmsspx_utilGetReg (ViSession instrumentHandle,
                                     ViInt32 registerName, ViPInt32 value);
ViStatus _VI_FUNC gmsspx_errorCheckState (ViSession instrumentHandle,
                                          ViBoolean state);
ViStatus _VI_FUNC gmsspx_writeInstrData (ViSession instrumentHandle,
                                         ViString writeBuffer);
ViStatus _VI_FUNC gmsspx_readInstrData (ViSession instrumentHandle,
                                        ViInt32 numberBytesToRead,
                                        ViChar _VI_FAR readBuffer[],
                                        ViPInt32 numBytesRead);
ViStatus _VI_FUNC gmsspx_reset (ViSession instrumentHandle);
ViStatus _VI_FUNC gmsspx_self_test (ViSession instrumentHandle,
                                    ViPInt16 selfTestResult,
                                    ViChar _VI_FAR selfTestMessage[]);
ViStatus _VI_FUNC gmsspx_diag (ViSession instrumentHandle,
                               ViChar _VI_FAR diagnosticsMessage[]);
ViStatus _VI_FUNC gmsspx_error_query (ViSession instrumentHandle,
                                      ViPInt32 errorCode,
                                      ViChar _VI_FAR errorMessage[]);
ViStatus _VI_FUNC gmsspx_error_message (ViSession instrumentHandle,
                                        ViStatus statusCode,
                                        ViChar _VI_FAR message[]);
ViStatus _VI_FUNC gmsspx_revision_query (ViSession instrumentHandle,
                                         ViChar _VI_FAR instrumentDriverRevision[],
                                         ViChar _VI_FAR firmwareRevision[]);
ViStatus _VI_FUNC gmsspx_utilSetDisplayState (ViSession instrumentHandle,
                                              ViBoolean displayState);
ViStatus _VI_FUNC gmsspx_utilGetDisplayState (ViSession instrumentHandle,
                                              ViPBoolean displayState);
ViStatus _VI_FUNC gmsspx_utilGetInstrModel (ViSession instrumentHandle,
                                            ViChar _VI_FAR instrumentModel[],
                                            ViPInt32 instrModelNumber);
ViStatus _VI_FUNC gmsspx_utilSetIODelay (ViSession instrumentHandle,
                                         ViReal64 IODelayTime);
ViStatus _VI_FUNC gmsspx_utilGetIODelay (ViSession instrumentHandle,
                                         ViPReal64 IODelayTime);
ViStatus _VI_FUNC gmsspx_utilAddress (ViSession instrumentHandle,
                                      ViInt32 addressOfInstrument);
ViStatus _VI_FUNC gmsspx_utilLockInstr (ViSession instrumentHandle,
                                        ViBoolean instrument);
ViStatus _VI_FUNC gmsspx_close (ViSession instrumentHandle);



#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
